package gov.va.vinci.dart.db;

import java.util.List;
import java.util.Set;

import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

import gov.va.vinci.dart.common.SingletonShim;
import gov.va.vinci.dart.common.exception.ObjectNotFoundException;
import gov.va.vinci.dart.common.test.BusinessIntegrationTest;
import gov.va.vinci.dart.biz.Group;
import gov.va.vinci.dart.biz.Person;
import gov.va.vinci.dart.service.DartObjectFactory;

public class TestGroupDAO extends BusinessIntegrationTest {

	@BeforeTest
	public void setup() {
		SingletonShim.getBean(DartObjectFactory.class);
	}
	
	@Test
	public void testOne() throws Exception {

		try {
			DartObjectFactory.getInstance().getGroupDAO().findById(0);
			Assert.fail("Expected ObjectNotFoundException");
		} catch (ObjectNotFoundException e) {}
		
		List<Group> groupList = DartObjectFactory.getInstance().getGroupDAO().listAll();
		 
		Assert.assertNotNull(groupList);
		Assert.assertTrue(groupList.size() > 0);
		 
	}

	@Test
	public void testTwo() throws Exception {

		try {
			DartObjectFactory.getInstance().getGroupDAO().findById(0);
			Assert.fail("Expected ObjectNotFoundException");
		} catch (ObjectNotFoundException e) {}
		
		List<Group> groupList = DartObjectFactory.getInstance().getGroupDAO().listAll();
		 
		Assert.assertNotNull(groupList);
		Assert.assertTrue(groupList.size() > 0);

		Group grp1 = groupList.get(0);
		Assert.assertNotNull(grp1);
		Assert.assertTrue(grp1.getId() > 0);
		
		Group grp2 = DartObjectFactory.getInstance().getGroupDAO().findById(grp1.getId());
		Assert.assertNotNull(grp2);
		Assert.assertEquals(grp2, grp1);
	}

	@Test
	public void testThree() throws Exception {

		try {
			DartObjectFactory.getInstance().getGroupDAO().findById(0);
			Assert.fail("Expected ObjectNotFoundException");
		} catch (ObjectNotFoundException e) {}
		
		List<Group> groupList = DartObjectFactory.getInstance().getGroupDAO().listAll();
		 
		Assert.assertNotNull(groupList);
		Assert.assertTrue(groupList.size() > 0);

		Group grp1 = groupList.get(0);
		Assert.assertNotNull(grp1);
		Assert.assertNotNull(grp1.getName());
		Assert.assertTrue(grp1.getName().length() > 0);
		
		Group grp2 = DartObjectFactory.getInstance().getGroupDAO().findByName(grp1.getName());
		Assert.assertNotNull(grp2);
		Assert.assertEquals(grp2, grp1);
	}
	
	@Test
	public void testFour() throws Exception {

		List<Group> groupList = DartObjectFactory.getInstance().getGroupDAO().listAll();
		 
		Assert.assertNotNull(groupList);
		Assert.assertTrue(groupList.size() > 0);

		// prime the person mock
		DartObjectFactory.getInstance().getPersonDAO().findById(1004);
		
		Group testGroup = null;
		
		// find a group with members
		for (Group grp : groupList) {
			Assert.assertNotNull(grp);
			Assert.assertNotNull(grp.getMembers());
			
			if (grp.getMembers().size() > 0) {
				testGroup = grp;
				break;
			}
		}
		
		Assert.assertNotNull(testGroup);
		
		// do all the members of this group think they belong to the group?
		for (Person pers : testGroup.getMembers()) {
			Set<Group> groups = pers.getGroups();
			Assert.assertNotNull(groups);
			Assert.assertTrue(groups.size() > 0);
			Assert.assertTrue(groups.contains(testGroup));
		}
	}

}
